--if exists(select 1 from sysobjects where xtype = 'P' and name = 'rep_inv_sell_lss')   drop procedure rep_inv_sell_lss
create proc rep_inv_sell_lss @inv varchar(30)
as
begin
  declare @snr varchar(30), @smass float , @amass float , @samt float, @aamt float, @rkg float
  Create table #lss (
             snr varchar(30) COLLATE DATABASE_DEFAULT primary key, 
             Item varchar(43) COLLATE DATABASE_DEFAULT,
             smass float, amass float, samt float,aamt float,qty float,rkg float,alt varchar(43), qts float)
  insert into #lss(snr,item,alt,qty,qts)
     Select
       s.nr, s.Descr,s.Alt,sum(a.Qty),sum(case when a.Memalt='NS' then 0 else a.Qty end)
       from AUCTSELL a, STOCK s where s.Nr= a.Stock and a.InvNo = @inv group by s.nr,s.Descr,s.Alt
    
  DECLARE c1 CURSOR FOR SELECT snr from #lss 
  OPEN c1
  FETCH NEXT FROM C1 INTO @snr
  WHILE @@FETCH_STATUS = 0
  BEGIN

    select @smass = sum(qty*Mass),
           @amass = case when sum(qty) = 0 then 0.00 else sum(qty*Mass)/sum(Qty) END,
           @samt = sum(Qty*ExAmt),
           @aamt = case when sum(Qty)=0 then 0.00 else sum(Qty*ExAmt)/sum(Qty) end
    from AUCTSELL where invno = @inv and memalt <> 'NS' and stock = @snr
    if @smass <> 0.0  select @rkg = @samt/@smass

    if exists(select 1 from  AUCTSELL where invno = @inv and memalt <> 'NS' and stock = @snr)
      update #lss set smass = @smass , amass = @amass , samt = @samt , aamt = @aamt, @rkg = rkg where snr = @snr
  
    FETCH NEXT FROM c1 INTO @snr

  END
  CLOSE c1
  DEALLOCATE c1
  
  select ITEM,QTY,SMASS,AMASS,SAMT,AAMT,RKG,ALT,QTS from #lss

end

